import argparse
import numpy as np

parser = argparse.ArgumentParser(description="config")
parser.add_argument("--input", type=str)
parser.add_argument("--output", type=str)
parser.add_argument("--max", type=float, default=2.0)
parser.add_argument("--min", type=float, default=0.05)
args = parser.parse_args()

f = open(args.input, "r")
g = open(args.output, "w")

lines = f.readlines()
lines = lines[1:]

idx = 0
label = 0
predict = 0
radius = 0
sigma = 0
flag = True
def output():
    if label == predict:
        correct = 1
    else:
        correct = 0
    string = "{}\t{}\t{}\t{}\t{:.3f}\t{:.3f}".format(idx, label, predict, correct, radius, sigma)
    if flag:
        print(string, file=g, flush=True)

for line in lines:
    line = line.split("\t")
    if float(line[-1]) == args.min:
        idx = int(line[0])
        label = int(line[1])
        predict = int(line[2])
        if label == predict:
            radius = float(line[3])
        else:
            radius = 0
        sigma = float(line[-1])
        flag = True
    elif float(line[-1]) == args.max:
        if int(line[2]) == label:
            if float(line[3]) > radius:
                radius = float(line[3])
                sigma = float(line[-1])
                predict = int(line[2])
        output()
        flag = False
    else:
        if int(line[2]) == label:
            if float(line[3]) > radius:
                radius = float(line[3])
                sigma = float(line[-1])
                predict = int(line[2])

f.close()
g.close()
    
